// partition.java
// Program dentonstruje operacj dzielenia danych zapisanych w tablicy
// Aby uruchomi program: C>java PartitionApp
////////////////////////////////////////////////////////////////
class ArrayPar
   {
   private long[] theArray;          // odwoanie do tablicy theArray
   private int nElems;               // ilo elementw
//--------------------------------------------------------------
   public ArrayPar(int max)          // konstruktor
      {
      theArray = new long[max];      // tworzymy tablic
      nElems = 0;                    // pocztkowo pust
      }
//--------------------------------------------------------------
   public void insert(long value)    // zapisanie elementu w tablicy
      {
      theArray[nElems] = value;      // wstawiamy element
      nElems++;                      // inkrementujemy rozmiar tablicy
      }
//--------------------------------------------------------------
   public int size()                 // zwrcenie iloci elementw
      { return nElems; }
//--------------------------------------------------------------
   public void display()             // wywietlenie zawartoci tablicy
      {
      System.out.print("A=");
      for(int j=0; j<nElems; j++)    // dla kadego elementu,
         System.out.print(theArray[j] + " ");  // wywietlamy go
      System.out.println("");
      }
//--------------------------------------------------------------
    public int partitionIt(int left, int right, long pivot)
       {
       int leftPtr = left - 1;           // umieszczany wskanik na prawo do 
                                         // od pierwszego elementu
       int rightPtr = right + 1;         // na i lewo od wartoci osiowej
       while(true)
          {
          while(leftPtr < right &&       // znajdujemy wikszy element
                theArray[++leftPtr] < pivot)
             ;  // (nic nie robimy)

          while(rightPtr > left &&       // znajdujemy mniejszy element
                theArray[--rightPtr] > pivot)
             ;  // (nic nie robimy)
          if(leftPtr >= rightPtr)        // jeli kolejno wskanikw si zmieni,
             break;                      //    podzia jest zakoczony
          else                           // kolejo nie ulega zmianie, 
             swap(leftPtr, rightPtr);    //    zatem zamieniamy elementy
          }  // koniec ptli while(true)
       return leftPtr;                   // zwracamy punkt podziau
       }  // koniec metody partitionIt()
//--------------------------------------------------------------
   public void swap(int dex1, int dex2)  // zamiana dwch elementw
      {
      long temp;
      temp = theArray[dex1];             // zapisujemy A w temp
      theArray[dex1] = theArray[dex2];   // zapisujemy B w A
      theArray[dex2] = temp;             // zapisujemy temp w B
      }  // koniec metody swap()
//--------------------------------------------------------------
   }  // koniec klasy ArrayPar
////////////////////////////////////////////////////////////////
class PartitionApp
   {
   public static void main(String[] args)
      {
      int maxSize = 16;             // wielko tablicy
      ArrayPar arr;                 // odwoanie do tablicy
      arr = new ArrayPar(maxSize);  // tworzymy tablic

      for(int j=0; j<maxSize; j++)  // zapisujemy w tablicy
         {                          // liczby losowe
         long n = (int)(java.lang.Math.random()*199);
         arr.insert(n);
         }
      arr.display();                // wywietlamy zawarto 
                                    // nieposortowanej tablicy

      long pivot = 99;              // warto osiowa
      System.out.print("Wartosc osiowa wynosi " + pivot);
      int size = arr.size();
                                    // podzia tablicy
      int partDex = arr.partitionIt(0, size-1, pivot);

      System.out.println(", Miejsce podziau na indeks " + partDex);
      arr.display();                // wywietlamy podzielon tablic 
      }  // koniec metody main()
   }  // koniec klasy PartitionApp
////////////////////////////////////////////////////////////////
